<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class studentrelation_m extends MY_Model {

	protected $_table_name = 'studentrelation';
	protected $_primary_key = 'studentrelationID';
	protected $_primary_filter = 'intval';
	protected $_order_by = "studentrelationID desc";
	

	public function __construct() 
	{
		parent::__construct();
	}

	protected $_extend_array = [
		'studentextendID',
		'studentgroupID',
		'optionalsubjectID',
		'extracurricularactivities',
		'remarks'
	];

	private function prefixLoad($array) {
		if(is_array($array)) {
			if(customCompute($array)) {
				foreach ($array as $arkey =>  $ar) {
					if(in_array($arkey, $this->_extend_array)) {
						unset($array[$arkey]);
						$array['studentextend.'.$arkey] = $ar;
					} elseif(substr($arkey, 0, 2) == 'sr') {
						unset($array[$arkey]);
						$array['studentrelation.'.$arkey] = $ar;
					} else {
						unset($array[$arkey]);
						$array['student.'.$arkey] = $ar;
					}
				}
			}
		}

		return $array;
	}


	public function get_studentrelation_join_student($arrays = array(), $single = FALSE) 
	{
		$reArray = array();
		if(inicompute($arrays)) {
			foreach ($arrays as $key => $array) {
				$reArray['studentrelation.'.$key] = $array; 		
			}
		}

		$this->db->select('*');
		$this->db->from('studentrelation');
		$this->db->join('student', 'student.studentID = studentrelation.srstudentID', 'LEFT');
		if(inicompute($arrays)) {
			$this->db->where($arrays);
		}
		$query = $this->db->get();

		if($single) {
			return $query->row();
		} else {
			return $query->result();
		}
	}

	public function get_studentrelation_join_student_with_student_extend($arrays = array(), $single = FALSE) 
	{
		$reArray = array();
		if(inicompute($arrays)) {
			foreach ($arrays as $key => $array) {
				$reArray['studentrelation.'.$key] = $array; 		
			}
		}

		$this->db->select('*');
		$this->db->from('studentrelation');
		$this->db->join('student', 'student.studentID = studentrelation.srstudentID', 'LEFT');
		$this->db->join('studentextend', 'studentextend.studentID = studentrelation.srstudentID', 'LEFT');
		if(inicompute($arrays)) {
			$this->db->where($arrays);
		}
		$query = $this->db->get();

		if($single) {
			return $query->row();
		} else {
			return $query->result();
		}
	}
	
	public function update_studentrelation_with_multicondition($array, $multiCondition) 
	{
		$this->db->update($this->_table_name, $array, $multiCondition);
	}

	public function get_studentrelation($array=NULL, $signal=FALSE) 
	{
		$query = parent::get($array, $signal);
		return $query;
	}

	public function get_order_by_studentrelation($array=NULL) 
	{
		$query = parent::get_order_by($array);
		return $query;
	}

	public function get_single_studentrelation($array=NULL) 
	{
		$query = parent::get_single($array);
		return $query;
	}

	public function insert_studentrelation($array) 
	{
		$error = parent::insert($array);
		return $error;
	}

	public function update_studentrelation($data, $id = NULL) 
	{
		parent::update($data, $id);
		return $id;
	}

	public function delete_studentrelation($id)
	{
		parent::delete($id);
	}

    public function get_studentrelation_studentArray($array=NULL, $key=FALSE) {
        $query = parent::get_where_in($array, $key);
        return $query;
    }

	public function general_get_single_student($arrays = [], $studentExtend = FALSE) {
		$arrays = $this->prefixLoad($arrays);
        $this->db->select('*');
        $this->db->from('studentrelation');
        $this->db->join('student', 'student.studentID = studentrelation.srstudentID', 'LEFT');

        if($studentExtend) {
        	$this->db->join('studentextend', 'studentextend.studentID = studentrelation.srstudentID', 'LEFT');
        }

        if(customCompute($arrays)) {
            $this->db->where($arrays);
        }
        $this->db->where('student.studentID !=', NULL);
        $this->db->order_by('srroll asc');
        $query = $this->db->get();
        return $query->row();
    }

	public function general_get_order_by_student($arrays = [], $studentExtend = FALSE) {
		$arrays = $this->prefixLoad($arrays);
        $this->db->select('*');
        $this->db->from('studentrelation');
        $this->db->join('student', 'student.studentID = studentrelation.srstudentID', 'LEFT');

        if($studentExtend) {
        	$this->db->join('studentextend', 'studentextend.studentID = studentrelation.srstudentID', 'LEFT');
        }

        if(customCompute($arrays)) {
            $this->db->where($arrays);
        }
        $this->db->where('student.studentID !=', NULL);
        $this->db->order_by('srroll asc');
        $query = $this->db->get();
        return $query->result();
    }
	
}
